
/** *
 *Classe per la gestione di un cono corrente con la gestione di interessi
 */
public class Interesse extends ContoCorrente
{
    /**
      * Tasso di interesse applicabile al conto corrente
      */
    public double tassoDiInteresse;
    
    /**
      * Costruttore che inizializza un nuovo conto corrente con saldo pari a 0 e un certo tasso di interesse
      * @param    tassoDiInteresse tasso di interesse applicabile al conto corrente
      */
    public Interesse(double tassoDiInteresse)
    {
        super();
        this.tassoDiInteresse = tassoDiInteresse;
    }
    
    /**
      * Costruttore che inizializza il contocorrente con un certo saldo iniziale e tesso di interesse
      * @param     saldoIniziale  saldo iniziale del conto corrente
      * @param     tassoDiInteresse  tasso di interesse del conto corrente
      */
    public Interesse(double saldoIniziale, double tassoDiInteresse)
    {
        super(saldoIniziale);
        this.tassoDiInteresse = tassoDiInteresse;
    }
    
    /**
      * Metodo per applicare l'interesse al conto corrente
      */
    public void applicaInteresse()
    {
        double interesse = super.getSaldo() * tassoDiInteresse / 100;
        versa(interesse);
    }
}
